/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.ConcordanceShell;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class ExtractConcordanceActionListener
implements ActionListener {
    private ConcordanceShellController controller;
    private boolean matchingTU;

    public ExtractConcordanceActionListener(ConcordanceShellController controller, boolean matchingTU) {
        this.controller = controller;
        this.matchingTU = matchingTU;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileNameExtensionFilter filter = new FileNameExtensionFilter("UTF-8 Text File (*.txt)", "txt");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setDialogTitle("Save As");
        jFileChooser.setFileFilter(filter);
        int result = jFileChooser.showSaveDialog(this.controller.getConcordanceShell());
        if (result == 0) {
            String parentPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
            String inputFileName = FilenameUtils.removeExtension(jFileChooser.getSelectedFile().getName()) + "." + "txt";
            String pathOfInputFile = parentPath + System.getProperty("file.separator") + inputFileName;
            File newFile = new File(pathOfInputFile);
            if (newFile.exists()) {
                int value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), inputFileName + " already exists." + " \n Do you want to replace it?", "Confirm Save As", 0, 2, null, null, null);
                if (value == 1 || value == -1) {
                    return;
                }
                newFile.delete();
                this.extractTextUnits(pathOfInputFile);
            } else {
                this.extractTextUnits(pathOfInputFile);
            }
        }
    }

    private void extractTextUnits(String pathOfFileToBeSaved) {
        PrintWriter pw = null;
        List<Object> theItems = this.controller.getTheItems();
        File txtFile = new File(pathOfFileToBeSaved);
        if (txtFile.exists()) {
            return;
        }
        try {
            txtFile.createNewFile();
            pw = new PrintWriter(txtFile);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot create sub-corpus " + txtFile.getName() + "\r" + e.getMessage(), "NooJ: cannot extract matching text units", 0);
            return;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot create sub-corpus " + txtFile.getName() + "\r" + e.getMessage(), "NooJ: cannot extract matching text units", 0);
            return;
        }
        TextEditorShellController textController = this.controller.getTextController();
        Ntext myText = textController.getMyText();
        boolean[] textUnitIsExported = new boolean[myText.mft.tuAddresses.length + 1];
        for (int i = 0; i < theItems.size(); i += 4) {
            int tuNb;
            boolean visible = (Boolean)theItems.get(i + 2);
            if (!visible) continue;
            Object[] item = (Object[])theItems.get(i + 1);
            if (!this.matchingTU && item[5] == null) {
                if (pw != null) {
                    pw.close();
                }
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Annotations are empty!", "NooJ: Annotations are empty!", 0);
                return;
            }
            ArrayList annotation = (ArrayList)item[5];
            double absoluteBeginAddress0 = (Double)annotation.get(2);
            double absoluteEndAddress0 = (Double)annotation.get(3);
            int absoluteBeginAddress = (int)absoluteBeginAddress0;
            int absoluteEndAddress = (int)absoluteEndAddress0;
            if (absoluteBeginAddress0 != absoluteEndAddress0 && absoluteBeginAddress == absoluteEndAddress) {
                while (Language.isLetter(myText.buffer.charAt(absoluteEndAddress))) {
                    ++absoluteEndAddress;
                }
            }
            if ((tuNb = ((Integer)annotation.get(0)).intValue()) == -1) {
                tuNb = textController.locateTextUnit(absoluteBeginAddress);
            }
            textUnitIsExported[tuNb] = true;
        }
        for (int iTU = 1; iTU < myText.mft.tuAddresses.length; ++iTU) {
            if ((!textUnitIsExported[iTU] || !this.matchingTU) && (textUnitIsExported[iTU] || this.matchingTU)) continue;
            int iTUindex = myText.mft.tuAddresses[iTU];
            pw.write("<TU>\n");
            pw.write(myText.buffer.substring(iTUindex, iTUindex + myText.mft.tuLengths[iTU]) + "\n");
            pw.write("</TU>\n\n");
        }
        pw.close();
        if (this.matchingTU) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: matching text units' corpus saved as " + txtFile.getName(), "NooJ Export Matching Text Units", 1);
        } else {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: non-matching text units' corpus saved as " + txtFile.getName(), "NooJ Export Non-Matching Text Units", 1);
        }
    }
}

